<?php /* configure.php * YeAPF application configure script * (C) 2016 Esteban D.Dortta */ /* find a file under a folder or set of folder */ function whereIs($fileName, $folderName) { $ret=false; $folderName=trim(str_replace("//", "/", $folderName)); if ($folderName>"") {
      
      if (strpos($folderName,';')!==false) {
        $folders=explode(';', $folderName);
        $ret=checkFolders($folders, $fileName);
        
      } else {
        if (file_exists("$folderName/$fileName")) {
          $ret="$folderName/";
        } else {
          $folders = array_filter(glob("$folderName/*"), 'is_dir');
          $ret=checkFolders($folders, $fileName);
        }
      }
    }
    return $ret;
  }

  function checkFolders($folders, $fileName) 
  {
    $ret=false;

    foreach($folders as $f) {
      $ret=whereIs($fileName, $f);
      if ($ret!==false)
        break;
    }     
    return $ret;
  };

  function qconfig($a) 
  {
    global $userContext, $sysDate, $u,
           $fieldValue, $fieldName,
           $userMsg, $xq_start;

    // will the data be sended using column names or column integer index?
    $useColNames = true;
    // numer of rows to limit queries result
    $countLimit=20;
    // return set.  Could be an array or an SQL statement
    $ret='';

    // publish query variables as local variables
    extract(xq_extractValuesFromQuery());
    $xq_start=isset($xq_start)?intval($xq_start):0;

    switch ($a) {
      case 'refreshAppRegistry':
        $ret=array( 'appRegistry' => UUID::v4());
        break;
    }

    xq_produceReturnLines($ret, $useColNames, $countLimit);
  };

  if (file_exists("yeapf.path"))
    $yeapfPath=file_get_contents("yeapf.path");
  else 
    $yeapfPath=isset($_SERVER['DOCUMENT_ROOT'])?$_SERVER['DOCUMENT_ROOT']:dirname(__FILE__);

  $yeapfPath=whereIs("yeapf.functions.php","$yeapfPath;../");
  if ($yeapfPath)
    file_put_contents("yeapf.path", $yeapfPath);
  else
    die("<h2>yeapf.includes.php not found</h2><p>Please indicate YeAPF! location at <b>yeapf.path</b> file</p>");

  /* void db connection */
  $dbConnect=false;
  /* load yeapf.functions.php */
  require_once "$yeapfPath/yeapf.functions.php";

  $cfgScriptName=basename(__FILE__);

  /* load e_configure */
  $i_configure=base64_decode("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");
  /* adjust configuration */
  $i_configure=str_replace("%(cfgScriptName)", "$cfgScriptName", $i_configure);

  if (isset($ts)) {
    qconfig($a);
    $xmlData=xq_produceContext($callBackFunction,$xq_return,$xq_regCount);
    header ("Content-Type:text/xml", true);
    echo "<?xml version='1.0' encoding='ISO-8859-1'?>\n";
    echo "<root>\n";
    echo "  $xmlData\n";
    echo " <sgug>\n";
    echo " <timestamp>$sysTimeStamp</timestamp>\n";
    echo "</sgug>\n";
    echo "</root>\n";
  } else {
    header("Content-Type:text/html", true);
    echo $i_configure;
  }
?>