<?php /* configure.php * YeAPF application configure script * (C) 2016 Esteban D.Dortta */ /* find a file under a folder or set of folder */ function whereIs($fileName, $folderName) { $ret=false; $folderName=trim(str_replace("//", "/", $folderName)); if ($folderName>"") {
      
      if (strpos($folderName,';')!==false) {
        $folders=explode(';', $folderName);
        $ret=checkFolders($folders, $fileName);
        
      } else {
        if (file_exists("$folderName/$fileName")) {
          $ret="$folderName/";
        } else {
          $folders = array_filter(glob("$folderName/*"), 'is_dir');
          $ret=checkFolders($folders, $fileName);
        }
      }
    }
    return $ret;
  }

  function checkFolders($folders, $fileName) 
  {
    $ret=false;

    foreach($folders as $f) {
      $ret=whereIs($fileName, $f);
      if ($ret!==false)
        break;
    }     
    return $ret;
  };

  function qconfig($a) 
  {
    global $userContext, $sysDate, $u,
           $fieldValue, $fieldName,
           $userMsg, $xq_start;

    // will the data be sended using column names or column integer index?
    $useColNames = true;
    // numer of rows to limit queries result
    $countLimit=20;
    // return set.  Could be an array or an SQL statement
    $ret='';

    // publish query variables as local variables
    extract(xq_extractValuesFromQuery());
    $xq_start=isset($xq_start)?intval($xq_start):0;

    switch ($a) {
      case 'refreshAppRegistry':
        $ret=array( 'appRegistry' => UUID::v4());
        break;
    }

    xq_produceReturnLines($ret, $useColNames, $countLimit);
  };

  if (file_exists("yeapf.path"))
    $yeapfPath=file_get_contents("yeapf.path");
  else 
    $yeapfPath=isset($_SERVER['DOCUMENT_ROOT'])?$_SERVER['DOCUMENT_ROOT']:dirname(__FILE__);

  $yeapfPath=whereIs("yeapf.functions.php","$yeapfPath;../");
  if ($yeapfPath)
    file_put_contents("yeapf.path", $yeapfPath);
  else
    die("<h2>yeapf.includes.php not found</h2><p>Please indicate YeAPF! location at <b>yeapf.path</b> file</p>");

  /* void db connection */
  $dbConnect=false;
  /* load yeapf.functions.php */
  require_once "$yeapfPath/yeapf.functions.php";

  $cfgScriptName=basename(__FILE__);

  /* load e_configure */
  $i_configure=base64_decode("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");
  /* adjust configuration */
  $i_configure=str_replace("%(cfgScriptName)", "$cfgScriptName", $i_configure);

  if (isset($ts)) {
    qconfig($a);
    $xmlData=xq_produceContext($callBackFunction,$xq_return,$xq_regCount);
    header ("Content-Type:text/xml", true);
    echo "<?xml version='1.0' encoding='ISO-8859-1'?>\n";
    echo "<root>\n";
    echo "  $xmlData\n";
    echo " <sgug>\n";
    echo " <timestamp>$sysTimeStamp</timestamp>\n";
    echo "</sgug>\n";
    echo "</root>\n";
  } else {
    header("Content-Type:text/html", true);
    echo $i_configure;
  }
?>