# **Welcome to YeAPF!**

    Copyright (C) 2004-2021 Esteban Daniel Dortta - dortta@yahoo.com - MIT License
    YeAPF 0.8.64-10 built on 2021-01-22 16:11 (-3 DST)
    Last file version: 2019-07-20 17:12:45 (-3 DST)

[pt-br](readme-pt-br.md) | [es](readme-es.md) 

**YeAPF!** means '**Yet Another PHP Framework**' and is a nerd celebration to [yacc](https://whatis.techtarget.com/definition/yacc-yet-another-compiler-compiler).

The purpose is to build an open tools that  helps other programmers to build faster and more stable applications.

The idea behind this is to keep all people producing using the same approach to API building for web applications, sites, desktop programs or mobile systems.

On the other hand, you can think agnostically. You can just use the part you believe is better for you and left all others.

It does not pretend to be light in the sense of how much it weight to be loaded. This is because the main idea is to build applications and not singles pages. But it pretends to be light in the sense of development, usage, data transfer between server(s) and client(s).

## Requirements
You will need php >= 5.4; php-mbstring; php-curl; php-iconv and the database connections (i.e. php-mysql, php-interbase, php-pgsql)

## Usage
You can just download and use or you can install the embedded tools.

The effect is the same but with the [tools](http://www.yeapf.com/wp/?p=455) you can achieve a richer and smooth experience because it help you in some day-to-day tasks.

## Samples
There are some samples included in the distro. You can just pick the sample of your interest, configure your folder and start to mess with that and learn how it works

## Skeletons
Beyond the samples, you can use pre-molded skeletons that will left your hands free just to implement your web/desktop/mobile events while you rests in PHP server side management.

## Interfaces
You can use xmlHttpRequest (Ajax), RestFUL, WebSocket, Server Side Events and SOAP WebService all with the same idea and the same structure. 

## CSS Frameworks
While you're free to use whatever CSS Framework you like, we deliver some samples and skeletons using BootStrap, Milligram, Materialize, Pure and Skeleton CSS frameworks you're free to use what yo do believe is better for your needs.

## Databases
You can use what do you prefer to keep your data (SQL, NoSQL, Graph) PDO or not... whatever. Meanwhile, we do offer a set of functions that are ready to work with MariaDB (MySQL), Firebird (Interbase) and Postgresql.

You just write your sql command an use these functions to query/update your data as you always do. But, if you use SQL92, you can just switch from one database to another with not so much suffering.

There is a tool (ydbmigrate) that helps you to convert a data set from one database server to another if you want that too.

Remember to read about how to use databases in our samples in this [document](readme-database-samples-en.md)

## Stability
Some applications are running for more than 10 years. From time to time, we need to do some improvements. Those changes are done in the mos careful way in order to no break legacy code. 

Meanwhile, you can just run together two, three, four different versions of YeAPF! in the same server. Just put *includes* files from the correct version into your *includes* app folder.

## Static pages application
You can produce static pages application as in any other server-side framework. The difference is that you can save those pages in a local cache and serve from here controlling that from the application itself and not from the server. It uses to have a big and good impact on server performance.

## Versioning
While git, svn and others helps you in development time, YeAPF! includes a tool (ydistbuilder) that help you to create a distribution version serving - at the same time - as a backup for prior versions. 

If you work alone, this will help you to keep stuff more well organized instead of taking care of each version as a different set of sources.

You can then use Docker, GitHub, BitBucket, OpenShift, Zip File, FTP or whatever you want to distribute it to your costumers.

## Documentation
YeAPF! is not well documented and we're working on it.
If you have free time and want to help, you're welcome!

The last document index was released in v0.8.56 and is available [here](http://yeapf.com/doc/0.8.56/index.html).

## Single Person Effort
You can contribute on free basis to this project via [PayPal](http://www.yeapf.com/paypal-en.html).

Questions (and answers) are welcome in this new [place](http://answers.yeapf.com/) and English, Portuguese and Spanish are accepted.

This project was started in 2004 and is in constantly growth. 