# **Bem-vindo ao YeAPF!**

    Copyright (C) 2004-2021 Esteban Daniel Dortta - dortta@yahoo.com - MIT License
    YeAPF 0.8.64-10 built on 2021-01-22 16:11 (-3 DST)
    Last file version: 2019-07-19 18:34:17 (-3 DST)

[en](readme-en.md) | [es](readme-es.md) 

**YeAPF!** significa '**Yet Another PHP Framework**' e é uma celebração nerd para [yacc](https://whatis.techtarget.com/definition/yacc-yet-another-compiler-compiler).

O objetivo é criar ferramentas abertas que ajudem outros programadores a criar aplicativos mais rápidos e mais estáveis.

A ideia por trás disso é manter todas as pessoas que produzem usando a mesma abordagem para a criação de APIs para aplicativos da Web, sites, programas de desktop ou sistemas móveis.

Por outro lado, você pode pensar agnosticamente. Você pode simplesmente usar a parte que acredita ser melhor para você e deixar todos os outros de lado.

Não pretende ser leve no sentido de quanto peso deve ser carregado. Isso ocorre porque a idéia principal é criar aplicativos e não páginas simples. Mas busca ser leve no sentido de desenvolvimento, uso, transferência de dados entre servidor(es) e cliente(s).

## Uso
Você pode simplesmente baixar e usar ou instalar as ferramentas incorporadas.

O efeito é o mesmo, mas com as [ferramentas](http://www.yeapf.com/wp/?p=455) você pode obter uma experiência mais rica e tranquila, pois o ajuda em algumas tarefas do dia-a-dia.

## Amostras
Existem algumas amostras incluídas na distro. Você pode escolher a amostra do seu interesse, configurar sua pasta e começar a mexer com isso e aprender como funciona.

## Esqueletos
Além das amostras, você pode usar esqueletos pré-moldados que deixarão suas mãos livres apenas para implementar seus eventos na web/desktop/móvel enquanto você se ocupa no gerenciamento do lado do servidor PHP.

## Interfaces
Você pode usar xmlHttpRequest(Ajax), RestFUL, WebSocket, Eventos do lado do servidor e SOAP WebService, todos com a mesma ideia e a mesma estrutura.

## CSS Frameworks
Enquanto você está livre para usar qualquer Framework CSS que você goste, nós entregamos algumas amostras e esqueletos usando frameworks CSS BootStrap, Milligram, Materialize, Pure e Skeleton, e você está livre para usar o que você acredita ser melhor para suas necessidades.

## Bancos de dados
Você pode usar o que você preferir para manter seus dados (SQL, NoSQL, Graph) PDO ou não ... o que for. Enquanto isso, oferecemos um conjunto de funções que estão prontas para trabalhar com o MariaDB (MySQL), Firebird (Interbase) e Postgresql.

Você aenas escreve seu comando sql e usa essas funções para consultar/atualizar seus dados como sempre faz. Mas, se você usar o SQL92, você pode simplesmente mudar de um banco de dados para outro com pouco sofrimento.

Existe uma ferramenta (ydbmigrate) que ajuda você a converter um conjunto de dados de um servidor de banco de dados para outro, se desejar também.

Lembre-se de ler sobre como usar bancos de dados em nossas amostras neste [documento](readme-database-samples-pt-br.md)

## Estabilidade
Algumas aplicações estão em execução há mais de 10 anos. De tempos em tempos, precisamos fazer algumas melhorias. Essas mudanças são feitas de forma cuidadosa, a fim de não quebrar o código legado.

Enquanto isso, você pode executar apenas duas, três, quatro versões diferentes do YeAPF! no mesmo servidor. Basta colocar os arquivos da *includes* da versão correta em sua pasta *includes* app.

## Aplicação de páginas estáticas
Você pode produzir aplicativos de páginas estáticas como em qualquer outra estrutura do lado do servidor. A diferença é que você pode salvar essas páginas em um cache local e servir a partir daqui controlando-as a partir do próprio aplicativo e não do servidor. Ele costuma ter um impacto grande e bom no desempenho do servidor.

## Versioning
Enquanto git, svn e outros o ajudam em tempo de desenvolvimento, o YeAPF! inclui uma ferramenta (ydistbuilder) que ajuda você a criar uma versão de distribuição servindo - ao mesmo tempo - como um backup para versões anteriores.

Se você trabalha sozinho, isso ajudará você a manter as coisas mais bem organizadas em vez de cuidar de cada versão como um conjunto diferente de fontes.

Você pode usar o Docker, o GitHub, o BitBucket, o OpenShift, o Zip File, o FTP ou o que você quiser distribuir para seus clientes.

## Documentation
YeAPF! não está bem documentado e estamos trabalhando nisso.
Se você tem tempo livre e quer ajudar, você é bem vindo!

O último índice do documento foi lançado na v0.8.56 e está disponível [aqui](http://yeapf.com/doc/0.8.56/index.html).

## Esforço Individual
Você pode contribuir com base gratuita para este projeto via [PayPal](http://www.yeapf.com/paypal-en.html).

Perguntas (e respostas) são bem-vindas neste novo [lugar](http://answers.yeapf.com/) e inglês, português e espanhol são aceitos.

Este projeto foi iniciado em 2004 e está em constante crescimento.