<?php /* configure.php * YeAPF application configure script * (C) 2016 Esteban D.Dortta */ /* find a file under a folder or set of folder */ function whereIs($fileName, $folderName) { $ret=false; $folderName=trim(str_replace("//", "/", $folderName)); if ($folderName>"") {

      if (strpos($folderName,';')!==false) {
        $folders=explode(';', $folderName);
        $ret=checkFolders($folders, $fileName);

      } else {
        if (file_exists("$folderName/$fileName")) {
          $ret="$folderName/";
        } else {
          $folders = array_filter(glob("$folderName/*"), 'is_dir');
          $ret=checkFolders($folders, $fileName);
        }
      }
    }
    return $ret;
  }

  function checkFolders($folders, $fileName)
  {
    $ret=false;

    foreach($folders as $f) {
      $ret=whereIs($fileName, $f);
      if ($ret!==false)
        break;
    }
    return $ret;
  };

  function qconfig($a)
  {
    global $userContext, $sysDate, $u,
           $fieldValue, $fieldName,
           $userMsg, $xq_start;

    // will the data be sended using column names or column integer index?
    $useColNames = true;
    // numer of rows to limit queries result
    $countLimit=20;
    // return set.  Could be an array or an SQL statement
    $ret='';

    // publish query variables as local variables
    extract(xq_extractValuesFromQuery());
    $xq_start=isset($xq_start)?intval($xq_start):0;

    switch ($a) {
      case 'refreshAppRegistry':
        $ret=array( 'appRegistry' => UUID::v4());
        break;
    }

    xq_produceReturnLines($ret, $useColNames, $countLimit);
  };

  if (file_exists("yeapf.path"))
    $yeapfPath=file_get_contents("yeapf.path");
  else {
    if (file_exists("search.path")) {
      $yeapfPath=file_get_contents("search.path");
    } else {
      $yeapfPath=isset($_SERVER['DOCUMENT_ROOT'])?$_SERVER['DOCUMENT_ROOT']:dirname(__FILE__);
    }
  }

  $main_folder_count=substr_count(dirname($_SERVER['REQUEST_URI']), "/");
  $main_folder=str_repeat("../", $main_folder_count);
  $main_folder=substr($main_folder,0,strlen($main_folder)-1);

  $yeapfPath=whereIs("yeapf.functions.php","$yeapfPath;includes;YeAPF/includes;.distribution/0.8.64/includes;YeAPF/.distribution/0.8.64/includes;lib;lib/YeAPF;lib/YeAPF/includes;../;$main_folder/includes;$main_folder/YeAPF/includes;$main_folder/.distribution/0.8.64/includes;$main_folder/YeAPF/.distribution/0.8.64/includes");
  if ($yeapfPath) {
    /* file_put_contents("yeapf.path", $yeapfPath); */
  } else {
    echo "<h2>yeapf.includes.php not found</h2><p>Please indicate YeAPF! location at <b>yeapf.path</b> file</p>";
    exit(20);
  }

  /* void db connection */
  $dbConnect=false;
  /* load yeapf.functions.php */
  require_once "$yeapfPath/yeapf.functions.php";

  $cfgScriptName=basename(__FILE__);

  /* load e_configure */
  $i_configure=base64_decode("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");
  /* adjust configuration */
  $i_configure=str_replace("%(cfgScriptName)", "$cfgScriptName", $i_configure);

  if (isset($ts)) {
    qconfig($a);
    $xmlData=xq_produceContext($callBackFunction,$xq_return,$xq_regCount);
    header ("Content-Type:text/xml", true);
    echo "<?xml version='1.0' encoding='ISO-8859-1'?>\n";
    echo "<root>\n";
    echo "  $xmlData\n";
    echo " <sgug>\n";
    echo " <timestamp>$sysTimeStamp</timestamp>\n";
    echo "</sgug>\n";
    echo "</root>\n";
  } else {
    header("Content-Type:text/html", true);
    echo $i_configure;
  }
?>